<?php

namespace App\Services\Api\Admin;

use App\Enums\UserTypeEnum;
use App\Http\Resources\api\AdminResource;
use App\Models\DeviceToken;
use App\Traits\HttpResponses;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class AuthService
{
    use HttpResponses;

    public function login($request)
    {
        try {


            $validator = Validator::make($request->all(), [
                'email' => 'required|email',
                'password' => 'required|string',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => false,
                    'errors' => $validator->errors(),
                ], 422);
            }

            $token = Auth::guard('admin_api')->attempt([
                'email' => $request->email,
                'password' => $request->password,
            ]);

            if ($token) {
                $user = Auth::guard('admin_api')->user();

                DeviceToken::updateOrCreate(
                    [
                        'user_id' => $user->id,
                        'mac_address' => $request->mac_address,
                        'device_type' => $request->device_type,
                        'user_type' => UserTypeEnum::ADMIN->value
                    ],
                    [
                        'token' => $request->device_token,
                        'user_id' => $user->id,
                        'device_type' => $request->device_type,
                        'mac_address' => $request->mac_address,
                        'user_type' => UserTypeEnum::ADMIN->value,
                    ]
                );
                $user['token'] = 'Bearer ' . $token;
                return $this->success('Login successful', AdminResource::make($user));
            } else {
                return $this->error('Login failed, check your credentials', null, 422);
            }

        } catch (\Exception $e) {
            return $this->error('');
        }

    }
}
