<?php

namespace App\Enums;

enum UserTypeEnum : string
{
    case ADMIN = 'admin';
    case USER = 'user';


    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }
    public function lang(): \Illuminate\Foundation\Application|array|string|\Illuminate\Contracts\Translation\Translator|\Illuminate\Contracts\Foundation\Application|null
    {
        return match ($this) {
            self::CLIENT => trans('admin'),
            self::LAWYER => trans('user'),
        };
    }
}
