<?php
namespace Database\Factories;

use App\Models\Patient;
use Illuminate\Database\Eloquent\Factories\Factory;

class PatientFactory extends Factory
{
    protected $model = Patient::class;

    public function definition(): array
    {
        return [
            'name_english' => $this->faker->name,
            'name_arabic' => $this->faker->name,
            'civil_id' => $this->faker->numerify('##############'), // Example civil ID
            'phone_number' => $this->faker->phoneNumber,
            'nationality' => $this->faker->country,
            'city' => $this->faker->city,
            'gender' => $this->faker->randomElement(['male', 'female']),
            'birth_date' => $this->faker->date('Y-m-d'),
            'address' => $this->faker->address,
            'notice' => $this->faker->sentence,
            'insurance_company' => $this->faker->company,
            'policy_holder' => $this->faker->name,
            'policy_number' => $this->faker->uuid,
            'policy_start_date' => $this->faker->date('Y-m-d'),
            'policy_end_date' => $this->faker->date('Y-m-d'),
            'how_did_you_know_about_us' => $this->faker->randomElement(['Internet', 'Friend', 'Ad']),
            'email' => $this->faker->safeEmail,
            // For file uploads, you might use a placeholder for now
            'civil_id_doc' => null,
            'patient_status_doc' => null,
            'report_1_doc' => null,
            'report_2_doc' => null,
            'other_document_doc' => null,
        ];
    }
}

