<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'cashier_id',
        'patient_id',
        'amount',
        'status',
        'payment_method',
        'transaction_id',
    ];

    public function cashier()
    {
        return $this->belongsTo(Cashier::class);
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }
}
