<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @method static findOrFail($id)
 * @method static create(mixed $validatedData)
 * @method static inRandomOrder()
 */
class ServiceGroup extends Model
{
    use HasFactory;
    protected $fillable=[
        'code',
        'name'
    ];



    public function service():HasMany
    {
        return $this->hasMany(Service::class,'service_group_id');
    }
    public function cashier():BelongsTo
    {
        return $this->belongsTo(Cashier::class,'doctor');
    }
}
