<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Doctor;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static where(string $string, $id)
 * @method static findOrFail($id)
 * @method static updateOrCreate(array $array)
 */
class Appointment extends Model
{
    use HasFactory;
//    protected $fillable=[
//        'doctor_name',
//        'service_name',
//        'date',
//        'start_time',
//        'end_time'
//    ];

    protected $guarded = [];

//    protected $casts = [
//        'date' => 'date',
//        'start_time' => 'datetime',
//        'end_time' => 'datetime',
//    ];

    protected $casts = [
        'date' => 'date:Y-m-d',
        'start_time' => 'datetime:H:i',
        'end_time' => 'datetime:H:i',
        'is_reserved' => 'boolean',
    ];

//    public function doctor()
//    {
//        return $this->belongsTo(Appointment::class,'doctor_name');
//    }


//    public static function isSlotAvailable($doctorName, $serviceName, $date, $startTime, $endTime)
//    {
//        return !self::where('doctor_name', $doctorName)
////            ->where('service_name', $serviceName)
//            ->where('date', $date)
//            ->where(function($query) use ($startTime, $endTime) {
//                $query->whereBetween('start_time', [$startTime, $endTime])
//                    ->orWhereBetween('end_time', [$startTime, $endTime])
//                    ->orWhere(function ($query) use ($startTime, $endTime) {
//                        $query->where('start_time', '<=', $startTime)
//                            ->where('end_time', '>=', $endTime);
//                    });
//            })
//            ->exists();
//    }

    public function doctor(): BelongsTo
    {
        return $this->belongsTo(Doctor::class,'doctor_id');
    }

    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class,'service_id');
    }




    /**
     * Generate intervals based on appointments for a specific doctor and date.
     *
     * @param int $doctorId
     * @param string $date
     * @return array
     */
    public static function generateIntervals(int $doctorId, string $date): array
    {
        if ($data=""){
            // Fetch all appointments for the given doctor and date
            $appointments = self::where('doctor_id', $doctorId)
                ->orderBy('start_time')
                ->get();
        }else{
            // Fetch all appointments for the given doctor and date
            $appointments = self::where('doctor_id', $doctorId)
                ->where('date', $date)
                ->orderBy('start_time')
                ->get();
        }


        // Get the doctor's working hours
        $doctor = Doctor::findOrFail($doctorId);
        $startOfDay = $doctor->start_time;
        $endOfDay = $doctor->end_time;

        // Initialize intervals array
        $intervals = [];
        $currentTime = $startOfDay;

        // Loop through appointments to create the intervals
        foreach ($appointments as $appointment) {
            // If there’s a gap before the appointment, mark as 'not reserved'
            if (strtotime($currentTime) < strtotime($appointment->start_time)) {
                $intervals[] = [
                    'start_time' => date('H:i', strtotime($currentTime)),
                    'end_time' => date('H:i', strtotime($appointment->start_time)),
                    'tag' => 'not reserved',
                ];
            }

            // Mark the appointment time as 'reserved'
            $intervals[] = [
                'start_time' => date('H:i', strtotime($appointment->start_time)),
                'end_time' => date('H:i', strtotime($appointment->end_time)),
                'tag' => 'reserved',
            ];

            // Update the current time to after this appointment
            $currentTime = $appointment->end_time;
        }

        // If there's remaining time after the last appointment, mark as 'not reserved'
        if (strtotime($currentTime) < strtotime($endOfDay)) {
            $intervals[] = [
                'start_time' => date('H:i', strtotime($currentTime)),
                'end_time' => date('H:i', strtotime($endOfDay)),
                'tag' => 'not reserved',
            ];
        }

        return $intervals;
    }




//    /**
//     * Generate intervals based on appointments for a specific doctor and date.
//     *
//     * @param int $doctorId
//     * @param string $date
//     * @return array
//     */
//    public static function generateIntervals(int $doctorId, string $date): array
//    {
//        // Fetch all appointments for the given doctor and date
//        $appointments = self::where('doctor_id', $doctorId)
//            ->where('date', $date)
//            ->orderBy('start_time')
//            ->get();
//
//        // Assuming the doctor model has start_time and end_time attributes
//        $doctor = Doctor::findOrFail($doctorId);
//        $startOfDay = $doctor->start_time;
//        $endOfDay = $doctor->end_time;
//
//        // Initialize intervals array with the whole day as 'not reserved'
//        $intervals = [
//            [
//                'start_time' => $startOfDay,
//                'end_time' => $endOfDay,
//                'tag' => 'not reserved',
//            ]
//        ];
//
//        // Process each appointment to adjust intervals
//        foreach ($appointments as $appointment) {
//            $newIntervals = [];
//            foreach ($intervals as $interval) {
//                if ($appointment->start_time < $interval['end_time'] && $appointment->end_time > $interval['start_time']) {
//                    // Split before the appointment if necessary
//                    if ($appointment->start_time > $interval['start_time']) {
//                        $newIntervals[] = [
//                            'start_time' => $interval['start_time'],
//                            'end_time' => $appointment->start_time,
//                            'tag' => 'not reserved',
//                        ];
//                    }
//
//                    // Mark the appointment time as 'reserved'
//                    $newIntervals[] = [
//                        'start_time' => max($interval['start_time'], $appointment->start_time),
//                        'end_time' => min($interval['end_time'], $appointment->end_time),
//                        'tag' => 'reserved',
//                    ];
//
//                    // Split after the appointment if necessary
//                    if ($appointment->end_time < $interval['end_time']) {
//                        $newIntervals[] = [
//                            'start_time' => $appointment->end_time,
//                            'end_time' => $interval['end_time'],
//                            'tag' => 'not reserved',
//                        ];
//                    }
//                } else {
//                    $newIntervals[] = $interval;
//                }
//            }
//            $intervals = $newIntervals;
//        }
//
//        // Ensure no duplicate intervals
//        return array_unique($intervals, SORT_REGULAR);
//    }
}
