<?php

    namespace App\Http\Services;

    use Illuminate\Support\Facades\Log;
    // use http\Client;
    // use Illuminate\Http\Request
    use GuzzleHttp\Client;
    use GuzzleHttp\Psr7\Request;
    class FatoorahService
    {
    private $base_url;
    private $headers;
    private $request_client;
    public function __construct(Client $request_client)
    {
        $this->request_client = $request_client;
        $this->base_url=env('fatoorah_base_url');
        $this->headers=[
            'Content-Type'=>'application/json',
            'authorization' => 'Bearer ' . env('fatoorah_token')    
        ];

    }
    private function buildRequest($uri,$method,$data=[]){
        $request = new Request($method,$this->base_url.$uri,$this->headers);//establish connection
        if(!$data)
            return false;
        $response = $this->request_client->send($request,[
            'json'=>$data
        ]);
        if($response->getStatusCode()!=200){
            return false;
        }
        $response=json_decode($response->getBody(),true);
        return $response;
    }
    public function sendPayment($data){
       $respanse = $this-> buildRequest('v2/SendPayment','POST',$data);
       return $respanse;
    }
    public function getPaymentStatus($data){
        $respanse = $this-> buildRequest('v2/getPaymentStatus','POST',$data);
        return $respanse;
     }
}
