<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ServiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'code' => $this->code,
            'name_english' => $this->name_english,
            'name_arabic' => $this->name_arabic,
            'QTY' => $this->QTY,
            'cost' => $this->cost,
            'price' => $this->price,
            'service_group' => new ServiceGroupResource($this->whenLoaded('serviceGroup')),
        ];
    }
}
