<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PatientResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name_english' => $this->name_english,
            'name_arabic' => $this->name_arabic,
            'email' => $this->email,
            'civil_id' => $this->civil_id,
            'phone_number' => $this->phone_number,
            'nationality' => $this->nationality,
            'city' => $this->city,
            'gender' => $this->gender,
            'birth_date' => $this->birth_date,
            'address' => $this->address,
            'insurance_company' => $this->insurance_company,
            'policy_holder' => $this->policy_holder,
            'policy_number' => $this->policy_number,
            'policy_start_date' => $this->policy_start_date,
            'policy_end_date' => $this->policy_end_date,
            'notice' => $this->notice,
            'how_did_you_know_about_us' => $this->how_did_you_know_about_us,
            'patient_status' => $this->patient_status,
            'report_1' => $this->report_1,
            'report_2' => $this->report_2,
            'other_document' => $this->other_document,
            'transactions' => $this->transactions // Assuming you want to include transactions
        ];
    }
}
