<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class CashierCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'data' => $this->collection->map(function($cashier) {
                return new CashierResource($cashier); // Use CashierResource for each item
            }),
            'meta' => [
                'total_cashiers' => $this->collection->count(),
            ]
        ];
    }
}
