<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Validation\ValidationException;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Validation\Rule;

class StorePatientRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }



    public function rules() : array
    {

//        $base = [
//            // 'name' => 'required|unique:items',
//            // 'code'=> 'required|unique:items',
//            'purchase_price' => 'required|numeric|gt:0',
//            'sale_price' => 'nullable|numeric|gt:0',
//            'category_id'=> 'required|integer|exists:item_categories,id',
//            'description' => 'nullable',
//            'name_en' => 'nullable',
//            'description_en' => 'nullable',
//            'origin_sale_price'=> 'required|numeric|gt:purchase_price',
//            'price_one'=> 'nullable|numeric|gt:0',
//            'price_two'=> 'nullable|numeric|gt:0',
//            'gomla_price'=> 'nullable|numeric|gt:0',
//            'item' => 'nullable|array',
//            'item.store_id' => [Rule::requiredIf($this->has('item')),'integer','exists:stores,id'],
//            'item.quantity' => [Rule::requiredIf($this->has('item')),'numeric','gt:0'],
//            'photo' => 'nullable|array',
//            'photo.*' => 'nullable|image|max:5070',
//            'photos'=>'nullable',
//            'photos.*' =>['mimes:jpeg,png,jpg,gif,svg','max:5070'],
//            'meta_title' => 'nullable',
//            'meta_description' => 'nullable',
//            'meta_keyword' => 'nullable',
//            'min_quantity'=>'required',
//            'is_main'=>'required',
//            'supplier' => 'required',
//        ];
//
//        if($this->method()=="POST"){
//            return array_merge($base,[
//                'name' => 'required|unique:items',
//                'code'=> 'required|unique:items',
//            ]);

        $patientId = $this->route('id'); // Get the patient ID from the route if available

        return [
            'name_english' => ['required', 'string', 'max:255'],
            'name_arabic' => ['required', 'string', 'max:255'],
            'civil_id' => [
                'required',
                'string',
//                'min:14',
//                'max:14',
                Rule::unique('patients')->ignore($patientId), // Apply unique rule with ignore
            /*
             * If the patient with ID 1 has a civil_id of 12345 and you try to update this patient with the same civil_id,
             *  the ignore(1) part ensures that the uniqueness check will not fail because it will skip checking the record with ID 1.
             * */
            ],
            'phone_number' => ['required', 'string', 'max:255'],
            'nationality' => ['required', 'string', 'max:255'],
            'city' => ['string', 'max:255'],
            'gender' => ['required', 'string', 'max:255', 'in:male,female'],
            'birth_date' => ['required', 'string', 'max:255'],
            'address' => ['string', 'max:255'],
            'notice' => ['string', 'max:255'],
            'insurance_company' => ['string', 'max:255'],
            'policy_holder' => ['string', 'max:255'],
            'policy_number' => ['string', 'max:255'],
            'policy_start_date' => ['string', 'max:255'],
            'policy_end_date' => ['string', 'max:255'],
            'how_did_you_know_about_us' => ['string', 'max:255'],
            'civil_id_doc' => ['image', 'mimes:jpeg,jpg,png,svg', 'max:2048'],
            'patient_status_doc' => ['image', 'mimes:jpeg,jpg,png,svg', 'max:2048'],
            'report_1_doc' => ['image', 'mimes:jpeg,jpg,png,svg', 'max:2048'],
            'report_2_doc' => ['image', 'mimes:jpeg,jpg,png,svg', 'max:2048'],
            'other_document_doc' => ['image', 'mimes:jpeg,jpg,png,svg', 'max:2048'],
            'email' => ['nullable', 'email', 'unique:patients,email'], // Add email validation
        ];
    }

    public function messages(): array
    {
        return [
            'civil_id.unique' => "This civil id already exists.",
            'civil_id.min' => "the civil id should be 14 consist of 14 number",
            'civil_id.max' => "the civil id should be 14 consist of 14 number",
            'password.required' => "The password field is required.",
            'civil_id.required' => "civil id field is empty",
            'phone_number.required' => "phone number field id is empty",
            'name_english.required' => "name in english field id is empty",
            'gender.required' => "gender field is empty",
            'gender.in' => "Gender must be either male or female.",
            'birth_date.required' => "birth date field is empty",

        ];
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function failedValidation(Validator $validator): array
    {
        $error = (new ValidationException($validator))->errors();
throw new HttpResponseException(response()->json([
    'status' => 'error',
    'message' => 'Validation failed',
    'data' => $error,
],422));

    }
}
