<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class GetAppointmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        // You can add authorization logic here if needed
        // For example, check if the user has permission to view appointments
        // return auth()->user()->can('view_appointments');

        // For simplicity, we'll return true
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'doctor_id' => 'required|string|exists:doctors,id',
            'date' => 'required|date',
        ];
    }

    /**
     * Customize the error messages for validation.
     */
    public function messages(): array
    {
        return [
            'doctor_id.required' => 'The doctor id is required.',
            'doctor_id.exists' => 'The selected doctor does not exist.',
            'date.required' => 'The date is required.',
            'date.date' => 'The date must be a valid date format.',
        ];
    }
}
