<?php

use App\Http\Controllers\AppointmentController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CashierController;
use App\Http\Controllers\ClinicController;
use App\Http\Controllers\DoctorController;
use App\Http\Controllers\PatientAttachmentController;
use App\Http\Controllers\PatientController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\ServiceGroupController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::controller(AuthController::class)->group(function (){
    Route::post('login','login');
    Route::post('register','register');
    Route::post('reset', 'resetPassword');
});

Route::controller(PatientController::class)->prefix('patient')->group(function () {
    Route::get( '/', 'index');
    Route::post('create',  'store');
    Route::get('/{id}', 'show')->whereNumber('id');
    Route::match(['put', 'patch'],'/{id}',  'update')->whereNumber('id');
    Route::delete('/{id}', 'destroy')->whereNumber('id');
});

Route::controller(PatientAttachmentController::class)->prefix('patientAttachment')->group(function () {
    Route::get('/','index');
    Route::post('/create','store');
    Route::get('/{id}','show')->whereNumber('id');
    Route::match(['put','patch'],'/{id}','update')->whereNumber('id');
    Route::delete('/{id}','destroy')->whereNumber('id');
});

Route::controller(DoctorController::class)->prefix('doctor')->group(function () {
    Route::get('/',  'index');

    Route::post('create',  'store');
    Route::get('/{id}',  'show')->whereNumber('id');
    Route::match(['put', 'patch'],'/{id}',  'update')->whereNumber('id');
    Route::delete('/{id}', 'destroy')->whereNumber('id');
});

Route::controller(ServiceController::class)->prefix('service')->group(function () {
    Route::get('/',  'index');
    Route::post('/create', 'store');
    Route::get('/{id}',  'show')->whereNumber('id');
    Route::match(['put', 'patch'], '/{id}', 'update')->whereNumber('id');
    Route::delete('/{id}', 'destroy')->whereNumber('id');
});
Route::controller(AppointmentController::class)->prefix('appointment')->group(function (){
    Route::post('/create','store');
    Route::get('/getAppointmentsByDoctor/{doctor_name}', 'getAppointmentsByDoctor');
    Route::get('/{doctor_name}/{date}', 'getAppointments');//get appointment by the doctor name and the date
    Route::match(['put', 'patch'],'/{id}','update')->whereNumber('id');
    Route::delete('/{id}',  'destroy')->whereNumber('id');
    //Route::post('appointment/{id}','show');
    //Route::get('/appointments/{doctor_name}','getAppointmentsByDoctor');
    //Route::get('/appointments/{doctor_name}/{date?}',getAppointmentsByDoctor');
});

Route::controller(ClinicController::class)->prefix('clinic')->group(function () {
    Route::get('/','index');
    Route::post('/create','store');
    Route::get('/{id}','show')->whereNumber('id');
//    Route::match(['put','patch'],'/{id}','update')->whereNumber('id');
        Route::put('/{id}','update')->whereNumber('id');

    Route::delete('/{id}','destroy')->whereNumber('id');
});

Route::controller(ServiceGroupController::class)->prefix("serviceGroup")->group(function (){
    Route::get('/','index');
    Route::post('/create', 'store');
    Route::get('/{id}',  'show')->whereNumber('id');
    Route::match(['put', 'patch'], '/{id}', 'update')->whereNumber('id');
    Route::delete('/{id}', 'destroy')->whereNumber('id');
});
Route::controller(CashierController::class)->prefix("cashier")->group(function (){
    Route::get('/','index');
    Route::post('/create', 'store');
    Route::get('/{id}',  'show')->whereNumber('id');
    Route::match(['put', 'patch'], '/{id}', 'update')->whereNumber('id');
    Route::delete('/{id}', 'destroy')->whereNumber('id');
});

Route::middleware(['auth:sanctum'])->group(function () {
    Route::post('logout', [AuthController::class, 'logout']);
});

