<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cashiers', function (Blueprint $table) {
            $table->id();

            $table->string('group',255);
//            $table->foreign('group')->references('name')->on('service_groups')->onDelete('cascade');;

            $table->string('code')->unique();//what should it be like ?
            $table->string('service',255);
            $table->foreign('service')->references('name_english')->on('services')->onDelete('cascade');;

            $table->string('doctor',255);
            $table->foreign('doctor')->references('name')->on('doctors')->onDelete('cascade');;
            $table->integer('QTY');
            $table->double('price', 8, 2); //see if we should connect this to the price in the services table
            $table->double('total', 8, 2);
            $table->double('discount', 8, 2);
            $table->double('value', 8, 2);
            $table->double('net_price', 8, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('cashiers', function (Blueprint $table) {
            $table->dropForeign(['group_name']);
            $table->dropForeign(['service']);
            $table->dropForeign(['doctor']);
        });
        Schema::dropIfExists('cashiers');
        Schema::dropIfExists('service_groups');
    }
};
