<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

/**
 * @method static create()
 * @method static findOrFail($id)
 */
class Cashier extends Model
{
    use HasFactory;
    protected $fillable=[
        'group',
        'code',
        'service',
        'doctor',
        'QTY',
        'price',
        'total',
        'discount',
        'value',
        'net_price'
    ];
    public function serviceGroups():HasOne
    {
        return $this->hasOne(ServiceGroup::class,'group');
    }
    public function service():HasOne
    {
        return $this->hasOne(Service::class,'service');
    }
    public function doctor():HasOne
    {
        return $this->hasOne(Doctor::class,'doctor');
    }

 }
