<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Doctor;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static where(string $string, $id)
 * @method static findOrFail($id)
 * @method static updateOrCreate(array $array)
 */
class Appointment extends Model
{
    use HasFactory;
//    protected $fillable=[
//        'doctor_name',
//        'service_name',
//        'date',
//        'start_time',
//        'end_time'
//    ];

    protected $guarded = [];

    protected $casts = [
        'date' => 'date',
        'start_time' => 'datetime',
        'end_time' => 'datetime',
        'is_reserved' => 'boolean',
    ];
//    public function doctor()
//    {
//        return $this->belongsTo(Appointment::class,'doctor_name');
//    }


//    public static function isSlotAvailable($doctorName, $serviceName, $date, $startTime, $endTime)
//    {
//        return !self::where('doctor_name', $doctorName)
////            ->where('service_name', $serviceName)
//            ->where('date', $date)
//            ->where(function($query) use ($startTime, $endTime) {
//                $query->whereBetween('start_time', [$startTime, $endTime])
//                    ->orWhereBetween('end_time', [$startTime, $endTime])
//                    ->orWhere(function ($query) use ($startTime, $endTime) {
//                        $query->where('start_time', '<=', $startTime)
//                            ->where('end_time', '>=', $endTime);
//                    });
//            })
//            ->exists();
//    }

    public function doctor(): BelongsTo
    {
        return $this->belongsTo(Doctor::class,'doctor_name');
    }

    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class,'service_name');
    }
}
