<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Validation\Rule;
use Illuminate\Validation\ValidationException;

class StoreClinicRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }


    public function rules(): array
    {
        $clinicId = $this->route('id'); // Get the doctor ID from the route if available

        return [
            'name_english' => [
                'required',
                'string',
                'max:255',
                $clinicId ? Rule::unique('clinics')->ignore($clinicId) : 'unique:clinics',
            ],
            'name_arabic' => [
                'required',
                'string',
                'max:255',
                $clinicId ? Rule::unique('clinics')->ignore($clinicId) : 'unique:clinics',
            ],
            'specialization' => ['required', 'string', 'max:255'],
            'location' => ['required', 'max:255','string'],
            'address' => ['required', 'max:255','string'],// التكلفه على العياده
            'phone' => [ 'required','string','max:255'],
            'mobile' => ['string', 'max:255'],
            'logo' => ['image', 'mimes:jpeg,jpg,png,svg', 'max:2048'],

        ];
    }


    public function messages(): array
    {

        return[
            'name_english.unique' => "This clinic english name already exists.",
            'name_arabic.unique' => "This clinic arabic name already exists.",
            'name_english.required' => "The english name field is required.",
            'name_arabic.required' => "The arabic name field is required.",
            'location.required' => "The location field is required.",
            'address.required' => "The address field is required.",
            'phone.required' => "The phone field is required.",
        ];

    }
    public function failedValidation(Validator $validator): array
    {
        $error = (new ValidationException($validator))->errors();
        throw new HttpResponseException(response()->json([
            'status'=>'error',
            'message'=>'Validation failed',
            'data'=>$error
        ],422));
    }
}
