<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreServiceGroupRequest;
use App\Http\Requests\StoreServiceRequest;
use App\Models\Service;
use App\Traits\HttpResponses;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    use HttpResponses;

    public function index(): JsonResponse
    {
        $service = Service::all();
        return response()->json($service);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreServiceRequest $request):JsonResponse
    {
        $validatedData=$request->validated();
//        dd($request->all());
        $service = Service::create($validatedData);
        return $this->success(['service'=>$service]);

    }


    /**
     * Display Service by id
     */
    public function show($id): JsonResponse
    {
        $service = Service::findOrFail($id);
        return response()->json($service);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(StoreServiceRequest $request, $id):JsonResponse
    {
        $service = Service::findOrFail($id);
        $validatedData = $request->validated();
        $service->update($validatedData);
        return $this->success($validatedData,"Service updated successfully");
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id): JsonResponse
    {
        $service = Service::findOrFail($id);
        $service->delete();
        return $this->success(null,"the service has been deleted successfully");
    }

}
