<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreDoctorRequest;
use App\Models\Doctor;
use App\Traits\HttpResponses;
use Illuminate\Http\JsonResponse;

class DoctorController extends Controller
{

    use HttpResponses;
    /**
     * Display Doctors
     */
    public function index(): JsonResponse
    {
        $doctor = Doctor::all();
        return response()->json($doctor);
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreDoctorRequest $request): JsonResponse
    {
        $validatedData=$request->validated();
        $validatedData['work_days'] = json_encode($validatedData['work_days'],true);
//        $validatedData['work_days'] =  array_values(json_decode($validatedData['work_days'], true));
        $doctor = Doctor::create($validatedData);
        return $this->success(
            ['doctor'=>$doctor]
        );
    }


    /**
     * Display doctor by id
     */
    public function show($id): JsonResponse
    {
        $doctor = Doctor::findOrFail($id);
        return response()->json($doctor);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(StoreDoctorRequest $request, $id):JsonResponse
    {
        $doctor = Doctor::findOrFail($id);
        $validatedData = $request->validated();
        $validatedData['work_days'] = json_encode($validatedData['work_days'],true);
        $doctor->update($validatedData);
        return $this->success($validatedData,"the doctor has been updated successfully");
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id): JsonResponse
    {
        $doctor = Doctor::findOrFail($id);
        $doctor->delete();
        return $this->success(null,"the doctor has been deleted successfully");
    }
}
