<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->string('name_english',255);
            $table->string('name_arabic',255)->nullable();
            $table->string('civil_id',20)->unique();
            $table->string('phone_number',15);
            $table->string('nationality');
            $table->string('city')->nullable();
            $table->enum('gender',['male','female']);
            $table->date('birth_date');
            $table->string('address')->nullable();
            $table->string('notice')->nullable();
            $table->string('insurance_company')->nullable();
            $table->string('policy_holder')->nullable();
            $table->string('policy_number')->nullable();
            $table->date('policy_start_date')->nullable();
            $table->date('policy_end_date')->nullable();
            $table->string('how_did_you_know_about_us')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customers');
    }
};
