<?php
namespace App\Http\Controllers;

use App\Http\Requests\LoginUserRequest;
use App\Http\Requests\ResetPasswordRequest;
use App\Http\Requests\StoreUserRequest;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use App\Traits\HttpResponses;

class AuthController extends Controller
{
use HttpResponses;

public function login(LoginUserRequest $request): \Illuminate\Http\JsonResponse
{
$credentials = $request->only('name', 'password');

if (!Auth::attempt($credentials)) {
return $this->error(null,"the password isn't correct", 401);
}
$user = Auth::user();
return $this->success([
'user' => $user,
'token' => $user->createToken('Token of ' . $user->name)->plainTextToken,
]);
}

public function register(StoreUserRequest $request): \Illuminate\Http\JsonResponse
{
    $user = User::create([
        'name' => $request->name,
        'password' => Hash::make($request->password),
    ]);

    return $this->success([
        'user' => $user,
        'token' => $user->createToken('Token of ' . $user->name)->plainTextToken,
    ]);
}
public function resetPassword(ResetPasswordRequest $request): \Illuminate\Http\JsonResponse
{
    $user = User::where('name', $request->name)->first();

    if (!Hash::check($request->old_password, $user->password)) {
        return $this->error(null, "The old password isn't correct.", 401);
    }

    $user->password = Hash::make($request->new_password);
    $user->save();

    return $this->success([
        'message' => 'Password has been successfully updated.',
    ]);
}

public function logout(): \Illuminate\Http\JsonResponse
{
    return $this->success([
    ]);
}
}
