<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patients', function (Blueprint $table) {
            $table->id();
            $table->string('name_english',255);
            $table->string('name_arabic',255)->nullable();
            $table->string('email')->unique()->nullable(); // Add email field
            $table->string('civil_id',20)->unique();// specify the number of numbers
            $table->string('phone_number',15);// specify the number of numbers
            $table->string('phone_home',15)->nullable();// specify the number of numbers
            $table->string('nationality');
            $table->string('city')->nullable();
            $table->enum('gender',['male','female']);
            $table->date('birth_date');
            $table->string('address')->nullable();
            $table->string('notice')->nullable();
            $table->string('insurance_company')->nullable();
            $table->string('policy_holder')->nullable();
            $table->string('policy_number')->nullable();
            $table->date('policy_start_date')->nullable();
            $table->date('policy_end_date')->nullable();
            $table->string('referral')->nullable();
//            $table->string('civil_id_doc')->nullable();
//            $table->string('patient_status_doc')->nullable();
//            $table->string('report_1_doc')->nullable();
//            $table->string('report_2_doc')->nullable();
//            $table->string('other_document_doc')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patients');
    }
};
