<?php

namespace Database\Factories;

use App\Models\Transaction;
use Illuminate\Database\Eloquent\Factories\Factory;

class TransactionFactory extends Factory
{
    protected $model = Transaction::class;

    public function definition()
    {
        return [
            'cashier_id' => \App\Models\Cashier::factory(),
            'patient_id' => \App\Models\Patient::factory(),
            'amount' => $this->faker->randomFloat(3, 0.200, 100000),
            'status' => $this->faker->randomElement(['pending', 'completed', 'failed']),
            'payment_method' => $this->faker->randomElement(['credit_card', 'knet', 'cash']),
            'transaction_id' => $this->faker->uuid,
        ];
    }
}
