<?php

namespace Database\Factories;

use App\Models\Doctor;
use App\Models\Service;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Random\RandomException;

class DoctorFactory extends Factory
{
    protected $model = Doctor::class;

    /**
     * @throws RandomException
     */
    public function definition()
    {
        // Generate a random start time
        $start_time = $this->faker->time('H:i', '22:00');

        // Ensure the end time is after the start time, adding at least 1 hour to the start time
        $end_time = \Carbon\Carbon::createFromFormat('H:i', $start_time)
            ->addMinutes(random_int(30, 120)) // Add between 30 minutes to 2 hours to ensure end_time is greater
            ->format('H:i');
        //createFromFormat : parse into the specified format

        return [
            'name' => $this->faker->name,
            'code' => $this->faker->unique()->numerify('DOC###'),
            'type' => $this->faker->randomElement(['General', 'Specialist']),
            'specialization' => $this->faker->word,
            'work_days' => $this->faker->randomElements(['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'], random_int(1, 7)),
            'start_time' => $start_time, // Generated start time
            'end_time' => $end_time,     // Calculated end time based on start time
        ];
    }

}
