<?php

namespace Database\Factories;

use App\Models\Clinic;
use Illuminate\Database\Eloquent\Factories\Factory;

class ClinicFactory extends Factory
{
    protected $model = Clinic::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name_english' => $this->faker->company,
            'name_arabic' => $this->faker->company,
            'specialization' => $this->faker->word,
            'location' => $this->faker->city,
            'address' => $this->faker->address,
            'phone' => $this->faker->phoneNumber,
            'mobile' => $this->faker->phoneNumber,
            'logo' => $this->faker->imageUrl(100, 100, 'clinic', true),  // For image URL
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }
}
