<?php
namespace Database\Factories;

use App\Models\Cashier;
use App\Models\Doctor;
use App\Models\Service;
use App\Models\ServiceGroup;
use Illuminate\Database\Eloquent\Factories\Factory;


class CashierFactory extends Factory
{
    protected $model = Cashier::class;

    public function definition()
    {
        $doctor = Doctor::inRandomOrder()->first();
        $serviceGroup=ServiceGroup::inRandomOrder()->first();
//        $service=Service::inRandomOrder()->first();

        $service = Service::where('service_group_id', $serviceGroup->id)->inRandomOrder()->first();
//        dd($service);
        return [
            'group' => $serviceGroup->name,
            'code' => $this->faker->numerify('####'),
            'service_id' => $service->id,
            'doctor_id' => $doctor->id,
            'QTY' => $this->faker->numberBetween(1, 10),
            'price' => $this->faker->randomFloat(2, 50, 200),
            'total' => $this->faker->randomFloat(2, 100, 1000),
            'discount' => $this->faker->numberBetween(0, 100),
            'value' => $this->faker->randomFloat(2, 10, 500),
            'net_price' => $this->faker->randomFloat(2, 50, 500),
        ];
    }
}
