<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\HasMany;

// * @method static create()
/**
 * @method static Cashier create(array $attributes = [])
 * @method static findOrFail($id)
 * @method static where(string $string, $serviceName)
 */
class Cashier extends Model
{
    use HasFactory;
    protected $fillable=[
        'group',
        'code',
        'service_id',
        'doctor_id',
        'QTY',
        'price',
        'total',
        'discount',
        'value',
        'net_price'
    ];
    public function serviceGroups():HasOne
    {
        return $this->hasOne(ServiceGroup::class,'group');
    }
    public function service():HasOne
    {
        return $this->hasOne(Service::class,'service');
    }
    public function doctor():HasOne
    {
        return $this->hasOne(Doctor::class,'doctor');
    }

    public function transactions(): HasMany
    {
        return $this->hasMany(Transaction::class);
    }


    /**
     * Calculate the total and other fields.
     *
     * @param array $validatedData
     * @param float $price
     * @return array
     */
    public static function calculateCashierData(array $validatedData, float $price): array
    {
        $QTY = $validatedData['QTY'];
        $discount = $validatedData['discount'];
        $total = $QTY * $price;
        $value = $total * $discount / 100;
        $net_price = $total - $value;

        return [
            'price' => $price,
            'total' => $total,
            'value' => $value,
            'net_price' => $net_price,
        ];
    }
}



