<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class TransactionCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'data' => $this->collection->transform(function ($transaction) {
                return [
                    'id' => $transaction->id,
                    'cashier_id' => $transaction->cashier_id,
                    'patient_id' => $transaction->patient_id,
                    'amount' => $transaction->amount,
                    'status' => $transaction->status,
                    'payment_method' => $transaction->payment_method,
                    'transaction_id' => $transaction->transaction_id,
                ];
            }),
        ];
    }
}
