<?php
namespace App\Http\Resources;

use App\Models\Doctor;
use App\Models\Service;
use Illuminate\Http\Resources\Json\JsonResource;

class CashierResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
//        dd($this->service_id);
        $service=Service::findOrFail($this->service_id);
//        dd($service);
        $doctor=Doctor::findOrFail($this->doctor_id);

        return [
            'id' => $this->id,
            'code' => $this->code,
            'group' => $this->group,
            'service_name' => $service->name_english,
            'doctor_name' => $doctor->name,
            'QTY' => $this->QTY,
            'price' => $this->price,
            'total' => $this->total,
            'discount' => $this->discount,
            'value' => $this->value,
            'net_price' => $this->net_price,
        ];
    }
}
