<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreHesabeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return false;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'merchantCode' => 'required',
            'access_code' => 'required', // Only for Indirect Integration
            'amount' => 'required|numeric|between:0.200,100000|regex:/^\d+(\.\d{1,3})?$/',
            'paymentType' => 'required|in:0,1,2',
            'responseUrl' => 'required|url',
            'failureUrl' => 'required|url',
            'version' => 'required'
        ];
    }
}
