<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class ResetPasswordRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'exists:users,name'],
            'old_password' => ['required', 'string', 'min:6'],
            'new_password' => ['required', 'string', 'min:6', 'confirmed'],
        ];
    }

    public function messages(): array
    {
        return [
            'name.exists' => "This user doesn't exist.",
            'old_password.required' => "The old password field is required.",
            'old_password.min' => "The old password must be at least 6 characters.",
            'new_password.required' => "The new password field is required.",
            'new_password.min' => "The new password must be at least 6 characters.",
            'new_password.confirmed' => "The new password confirmation does not match.",
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        $errors = (new \Illuminate\Validation\ValidationException($validator))->errors();

        throw new HttpResponseException(response()->json([
            'status' => 'error',
            'message' => 'Validation failed',
            'data' => $errors,
        ], 422));
    }
}
